/*
	    Script che aggiunge nella tabella delle causali prestazioni professionisti
		un nuovo campo flag che indica se la ritenuta calcolata deve essere considerata
		a TITOLO DI IMPOSTA e non a titolo di acconto

		Aggiorna il flag in assenza di tipologia reddituale o su tipologie reddituali V, V2 e J
*/

-------------------------------------------------------------------------------------------------------------------------
IF NOT EXISTS(SELECT * FROM SYSCOLUMNS WHERE NAME = 'CG15_FLGRITIMPOSTA')
  BEGIN
    ALTER TABLE CG15_TABCAUPREST
      ADD CG15_FLGRITIMPOSTA		TINYINT	NOT NULL	DEFAULT 0
    
    PRINT 'Tabella CG15_TABCAUPREST: campo CG15_FLGRITIMPOSTA creato.'
  END
ELSE
  PRINT 'Tabella CG15_TABCAUPREST: campo CG15_FLGRITIMPOSTA esistente, creazione non effettuata.'
GO
-------------------------------------------------------------------------------------------------------------------------
BEGIN
	UPDATE CG15_TABCAUPREST SET CG15_FLGRITIMPOSTA = 1
	WHERE  (LTRIM(RTRIM(ISNULL(CG15_CAUSDD1, ''))) = '' AND CG15_FLGRITIMPOSTA = 0)
        OR (LTRIM(RTRIM(ISNULL(CG15_CAUSDD1, ''))) = 'V' AND CG15_FLGRITIMPOSTA = 0)
	    OR (LTRIM(RTRIM(ISNULL(CG15_CAUSDD1, ''))) = 'V2' AND CG15_FLGRITIMPOSTA = 0)
	    OR (LTRIM(RTRIM(ISNULL(CG15_CAUSDD1, ''))) = 'J' AND CG15_FLGRITIMPOSTA = 0)

	PRINT 'Tabella CG15_TABCAUPREST: campo CG15_FLGRITIMPOSTA aggiornato per le tipologie reddituali V, V2 e J'
END
GO
-------------------------------------------------------------------------------------------------------------------------